//
//  GSBasePen.h
//  GlyphsCore
//
//  Created by Georg Seifert on 16.11.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <GlyphsCore/GSPenProtocol.h>

@class GSFont;

@interface GSBasePen : NSObject <GSPenProtocol> {
	GSFont *_glyphSet;
	NSPoint _lastPoint;
	NSAffineTransform *_transform;
}
@property (nonatomic, assign) NSPoint lastPoint;

@property (nonatomic, strong) NSAffineTransform *transform;

#ifndef GLYPHS_VIEWER
@property (nonatomic) BOOL optimiseQuadratic2Cubic;
#endif

@property (nonatomic) BOOL convertQuadratic2Cubic;

- (instancetype)initWithGlyphSet:(id)glyphSet;

@end
